# install.packages("ggplot2")

library(ggplot2)

# Set workspace
setwd("enter your folder here")

# Read text file
df <- read.csv(file="OM S18 dataset.csv",head=TRUE,sep=",")

# Print data frame
df

# Make plot
OMS18 <- ggplot() +
  geom_rect(aes(xmin=1171.5, xmax=1178.5, ymin=0, ymax=Inf)) +
  geom_point(data = df, aes(x = avgcmOD, y = X.OM), colour="black", size=2, shape=21, fill="violetred2") + 
  xlab(' ') +
  ylab('Organic matter content [%]') +
  geom_hline(yintercept=40,linetype="dashed",size=1) +
  geom_vline(xintercept=1172.5,linetype="dotted",size=1) +
  geom_vline(xintercept=1173.5,linetype="dotted",size=1) +
  xlim(1164.5, 1180.5) +
  ylim(0, 100) +
  coord_flip()

# Show plot
OMS18

# Save plot
ggsave("OMS18.pdf", plot=OMS18, height=17.5, width=10, units=c("cm"), dpi=600)